/*Codice SAS per riprodurre la relazione fra la moda delle distribuzioni di probabilit della Loss di un portafoglio e la correlazione di default ? (figura 43)*/

ods html close; 
ods html;
proc iml;

N=100;
pd=0.4; 
p0=pd;

LB= (pd-1)/pd;
if pd<0.5 then LB=1/LB;
print LB;
epsilon1 = 0.01/2;
LB = LB+epsilon1;
print LB;

/* Salviamo questi valori in macrovariabili */
CALL SYMPUTX("N", N);
CALL SYMPUTX("PD", pd);

free allpdf params modes; /*inizializzazione della matrice allpdf*/
do ro= LB to 0.99 by .01; /*creo un grande ciclo che itera in base a rho, poich alpha e beta dipendono da q che a sua volta dipende da rho. Quindi in base alla correlazione rho tra i default si avr una distribuzione di probabilit diversa*/

	I=pd*(1-pd);
	L=p0*(1-p0);
	q=(sqrt(I)*sqrt(L)*ro)+(pd*p0);
	
	D=(pd-q)/(1-p0-pd+q);
	E=(q/(p0-q))*((1-p0-pd+q)/(pd-q));
	F=(1-p0)/p0;
	G=(p0-q)/(1-p0-pd+q);

	alpha=log(D);
	alphazero=((N-1)*log(F))+(N*log(G));
	beta= log(E);
	params=params//(ro||alpha||alphazero||beta);
	H=alpha+beta;
	Z=((1+exp(alpha))##N) + ( exp(alphazero)*(1+exp(H))##N );
	somma_pdf=j(N+1,3,.);

	do ll=0 to N;
		coeff_bin= comb(N, ll);
		A= 1/Z;
		B= alpha * ll;
		C= alphazero + (ll*(alpha + beta));
		exp_B = exp(B);
		exp_C = exp(C);
		somma_pdf[ll+1,1]=ll; /* ll+1,  per iniziare dalla riga 1, perch la 0 non esiste*/
		somma_pdf[ll+1,2] = A * coeff_bin * (exp_B + exp_C); /* Calcola la densit di probabilit DISCRETA PMF*/
		somma_pdf[ll+1,3]=ro;
	end;

	allpdf=allpdf//somma_pdf; /*appende due matrici una sotto l'altra per le varie correlazioni*/

    maxProb1 = max(somma_pdf[,2]);  /* Identifica il valore di X corrispondente alla probabilit massima */
    modeVals1 = somma_pdf[loc(somma_pdf[,2] = maxProb1),1];
    modes=modes//(ro||modeVals1||maxProb1);

end; /*end del ciclo rho*/  
lossNorm=allpdf[,1]/N*100; /* normalizzazione del valore sull'asse x*/
allpdf=allpdf||lossNorm; /* accosta i due vettori colonna per colonna*/

create plt_pdf from allpdf[colname={"somma" "pdf" "rho" "lossnorm"}]; /* Creazione del dataset con i nomi delle colonne */
    /* Aggiunta di una riga al dataset */
    append from allpdf; /* Appendiamo una riga con i valori di som e ff */
    close plt_pdf; /* Chiusura del dataset */
    create params from params[colname={"rho" "alpha" "alphazero" "beta"}];
    append from params; 
    close params; /* Chiusura del dataset */

/* Calcolo della moda*/
    create modes from modes[colname={"rho" "mode" "prob_mode"}];
    append from modes; /* Appendiamo una riga con i valori di som e ff */
    close modes; /* Chiusura del dataset */

proc sgplot data=modes;
scatter x=rho y=mode; /* Traccia il grafico a LINEE*/
title "Dandelion - Distribuzione di Probabilit  N=&N PD=&PD - Andamento della moda in relazione con rho";
run;
 
